package com.izenpe.zain.cliente.wss;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartDecryptRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartDecryptResponse;

public class WssDecryption {
	
	private static final String fileName = "WSSEncrypted.xml";
	
    public static void main(String args[]) throws Exception {   	    	
    	try{
	    	// Asignacin de la configuracin de forma programtica
			ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);
	    	
			/*
			 * Se crea la peticin a travs de la URL definida en ZAIN_ENDPOINT.
			 */
	    	SmartDecryptRequest dReq = new SmartDecryptRequest(Propiedades.ZAIN_ENDPOINT);
			
	    	// Se establece el perfil WSS
			dReq.setProfile(Constants.Profile.WSS);
			 
			// Datos a descifrar
			dReq.setEnvelopeXml(new String(ZainUtil.readBinaryFile("data/output/" + fileName)));        
			   
			// Envo de la peticin
			SmartDecryptResponse dRes =  dReq.send();
			
			// Se comprueba la validez de la respuesta de Descifrado
			if (Constantes.RMAJOR_SUCCESS.equals(dRes.getResultMajor())            
					&& dRes.getResultMinor() == null) {  
				System.out.println("Decryption OK");
				System.out.println("   Decrypted data:\n      " + dRes.getDocumentXmlData());
				String decrypted = dRes.getDocumentXmlData();
				String destFilename = "data/output/WSSDecrypted.xml";
				ZainUtil.writeBinaryFile(destFilename, decrypted.getBytes());
			} else {
				throw new Exception("Error decrypting: " + dRes.getResultMinor());
	    	}
    	}catch (Exception e) {
    		System.out.println("Error en la encriptacin de un WSS");
    		e.printStackTrace();
    	}
	}

}
